{*
* 2007-2016 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <info@mensagia.com>
*  @copyright  2017 Sinermedia
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}

<div class="panel">
    <div class="panel-heading"><i class="icon-external-link"></i> {l s='Export to Mensagia' mod='mensagiaprestashop'}</div>
    <div class="panel-body">

        <form id="exportar_form" class="defaultForm form-horizontal mensagiaprestashop" action="{$action}" method="post" enctype="multipart/form-data" novalidate="" autocomplete="off">

            <div class="form-group">
                <label class="control-label col-lg-3">
                    {l s='Choose which groups you want to export to Mensagia ' mod='mensagiaprestashop'}
                </label>

                <div class="col-lg-9">
                    {if ($groups)}

                        {foreach from=$groups item=curr}
                            <label for="group_{$curr['id_group']}" style="cursor:pointer;"> <input type="checkbox" id="group_{$curr['id_group']}" name="group_{$curr['id_group']}" group_id="{$curr['id_group']}" group_name="{$curr['name']}" class="groupsToExport" value="1"> {$curr['name']}</label><br>
                        {/foreach}

                        <div class="error error_export" style="color:red;font-weight:bold;margin-top:10px;display:none;">{l s='You must choose at least one group to export to Mensagia' mod='mensagiaprestashop'}</div>

                    {/if}
                </div>
            </div>

            <div class="form-group" style="margin-top:30px;">
                <label class="control-label col-lg-3" for="prefix_agenda">
                    {l s='Choose the prefix to create the schedule ' mod='mensagiaprestashop'}
                </label>

                <div class="col-lg-9">
                    <input type="text" id="prefix_agenda" name="prefix_agenda" class="" value="{$shop_name}_{$date_prefix}_">
                    <span id="helpBlockAgendas" class="help-block" style="display:none;">{l s='The following agendas will be created on Mensagia:' mod='mensagiaprestashop'} <span id="helpBlockAgendasNames"></span></span>
                </div>
            </div>


            <div class="form-group" style="margin-top:30px;">
                <label class="control-label col-lg-3">
                    {l s='If this agenda already exists in Mensagia, do you want to delete it?' mod='mensagiaprestashop'}
                </label>

                <div class="col-lg-9">
                    <p class="radio">
                        <label for="radioNO" style="font-weight:bold;"><input type="radio" id="radioNO" name="delete_agendas" class="" value="0" checked>{l s='No' mod='mensagiaprestashop'}</label> <br>
                    </p>
                    <p class="radio">
                        <label for="radioSI" style="font-weight:bold;"><input type="radio" id="radioSI" name="delete_agendas" class="" value="1">{l s='Yes' mod='mensagiaprestashop'}</label>
                    </p>
                </div>
            </div>


            <div class="form-group" style="margin-top:30px;">
                <label class="control-label col-lg-3">
                    {l s='Synchronize Mensagia Black List with the field "Accept newsletters"' mod='mensagiaprestashop'}
                </label>

                <div class="col-lg-9">
                    <p class="radio">
                        <label for="radioNONewsletter" style="font-weight:bold;"><input type="radio" id="radioNONewsletter" name="blacklist_with_newsletter" class="radioBlacklist" value="0" checked>{l s='No' mod='mensagiaprestashop'}</label> <br>
                    </p>
                    <p class="radio">
                        <label for="radioSINewsletter" style="font-weight:bold;"><input type="radio" id="radioSINewsletter" name="blacklist_with_newsletter" class="radioBlacklist" value="1">{l s='Yes' mod='mensagiaprestashop'} </label>
                    </p>

                    <div class='listanegrabox' style="margin-left:18px;margin-top:10px;background:#eee;padding:10px;display:none;">
                        <p>{l s='If customers do not accept Newsletters, will be added to the following BlackLists. If customers accept Newsletters, will be deleted from the following BlackLists' mod='mensagiaprestashop'}:</p>
                        <p class="radio" style="margin-top:-10px !important;">
                            <label for="radioSMS" style="font-weight:bold;"> <input type="checkbox" id="radioSMS" name="sms_blacklist" checked value="1"> {l s='SMS BlackList' mod='mensagiaprestashop'}</label> <br>
                        </p>
                        <p class="radio">
                            <label for="radioEmail" style="font-weight:bold;"> <input  type="checkbox" id="radioEmail" name="mail_blacklist" checked  value="1"> {l s='Email BlackList' mod='mensagiaprestashop'}</label>
                        </p>
                        <p class="radio">
                            <label for="radioVoz" style="font-weight:bold;"> <input type="checkbox" id="radioVoz" name="voz_blacklist" checked  value="1"> {l s='Voice BlackList' mod='mensagiaprestashop'}</label>
                        </p>

                        <div class="error error_no_blacklists" style="color:red;font-weight:bold;margin-top:10px;display:none;">{l s='You must choose at least one BlackList' mod='mensagiaprestashop'}</div>

                    </div>
                </div>
            </div>

            <div class="form-group" style="margin-top:30px;">
                <label class="control-label col-lg-3">
                    {l s='Fields to export' mod='mensagiaprestashop'}
                </label>

                <div class="col-lg-9">
                    <div class="row" style="border:1px solid #ddd;padding:20px;">
                        <div class="col-lg-3">
                            <div class="checks">
                                <b style="margin-bottom: 10px;display: block;text-decoration:underline;">{l s='Customers' mod='mensagiaprestashop'}</b>
                                <label for="ps_phone" style="cursor:pointer;"> <input type="checkbox" id="ps_phone" name="ps_phone"  class="ps_contact" value="1" > {l s='Mobile phone' mod='mensagiaprestashop'} </label><br>
                                <label for="ps_email" style="cursor:pointer;"> <input type="checkbox" id="ps_email" name="ps_email"  class="ps_contact" value="1" > {l s='Email' mod='mensagiaprestashop'} </label><br>
                                <label for="ps_name" style="cursor:pointer;"> <input type="checkbox" id="ps_name" name="ps_name"  class="ps_contact" value="1" > {l s='Name and lastname' mod='mensagiaprestashop'} </label><br>
                                <label for="ps_firstname" style="cursor:pointer;"> <input type="checkbox" id="ps_firstname" name="ps_firstname"  ps_group="customer"  class="ps_extrafields" extra_field_type="string" value="1" date_format_type="" > {l s='Firstname as extrafield' mod='mensagiaprestashop'} </label><br>
                                <label for="ps_lastname" style="cursor:pointer;"> <input type="checkbox" id="ps_lastname" name="ps_lastname"  ps_group="customer"  class="ps_extrafields" extra_field_type="string" value="1" date_format_type="" > {l s='Lastname as extrafield' mod='mensagiaprestashop'} </label><br>
                                <label for="ps_city" style="cursor:pointer;"> <input type="checkbox" id="ps_city" name="ps_city"  class="ps_contact" value="1" > {l s='City' mod='mensagiaprestashop'} </label><br>
                                <label for="ps_address_state" style="cursor:pointer;"> <input type="checkbox" id="ps_address_state" name="ps_address_state"  ps_group="address" class="ps_extrafields" extra_field_type="string" value="1" date_format_type="" > {l s='Province or state' mod='mensagiaprestashop'} </label><br>
                                <label for="ps_country" style="cursor:pointer;"> <input type="checkbox" id="ps_country" name="ps_country"  ps_group="address"  class="ps_extrafields" extra_field_type="string" value="1" date_format_type="" > {l s='Country' mod='mensagiaprestashop'} </label><br>
                                <label for="ps_language" style="cursor:pointer;"> <input type="checkbox" id="ps_language" name="ps_language"  class="ps_contact" value="1" > {l s='Language' mod='mensagiaprestashop'} </label><br>
                                <label for="ps_id_customer" style="cursor:pointer;" data-toggle="tooltip" title="{l s='Mensagia extra field' mod='mensagiaprestashop'}: ps_id_customer"> <input type="checkbox" id="ps_id_customer" ps_group="customer" nameToShow="{l s='Customer ID' mod='mensagiaprestashop'}" extra_field_type="number" class="ps_extrafields" value="1" date_format_type=""> {l s='Customer ID' mod='mensagiaprestashop'} </label><br>
                                <label for="ps_id_default_group" style="cursor:pointer;" data-toggle="tooltip" title="{l s='Mensagia extra field' mod='mensagiaprestashop'}: ps_id_default_group"> <input type="checkbox" id="ps_id_default_group" name="ps_id_default_group" ps_group="customer" nameToShow="{l s='Client group ID' mod='mensagiaprestashop'}" name="ps_id_default_group" extra_field_type="number" class="ps_extrafields" value="1" date_format_type=""> {l s='Client group ID' mod='mensagiaprestashop'} </label><br>
                                <label for="ps_id_lang" style="cursor:pointer;" data-toggle="tooltip" title="{l s='Mensagia extra field' mod='mensagiaprestashop'}: ps_id_lang"> <input type="checkbox" id="ps_id_lang" name="ps_id_lang" ps_group="customer" nameToShow="{l s='Language ID' mod='mensagiaprestashop'}" class="ps_extrafields" extra_field_type="number" value="1" date_format_type=""> {l s='Language ID' mod='mensagiaprestashop'} </label><br>
                                <label for="ps_company" style="cursor:pointer;" data-toggle="tooltip" title="{l s='Mensagia extra field' mod='mensagiaprestashop'}: ps_company"> <input type="checkbox" id="ps_company" name="ps_company" ps_group="customer" nameToShow="{l s='Company' mod='mensagiaprestashop'}" class="ps_extrafields" extra_field_type="string" value="1" date_format_type=""> {l s='Company' mod='mensagiaprestashop'} </label><br>
                                <label for="ps_birthday" style="cursor:pointer;" data-toggle="tooltip" title="{l s='Mensagia extra field' mod='mensagiaprestashop'}: ps_birthday"> <input type="checkbox" id="ps_birthday" name="ps_birthday" ps_group="customer" nameToShow="{l s='Date of birth' mod='mensagiaprestashop'}" class="ps_extrafields" extra_field_type="date" date_format_type="date_format_lite" value="1"> {l s='Date of birth' mod='mensagiaprestashop'} </label><br>
                                <label for="ps_date_add" style="cursor:pointer;" data-toggle="tooltip" title="{l s='Mensagia extra field' mod='mensagiaprestashop'}: ps_date_add"> <input type="checkbox" id="ps_date_add" name="ps_date_add" ps_group="customer" nameToShow="{l s='Creation date' mod='mensagiaprestashop'}" class="ps_extrafields" extra_field_type="date" date_format_type="date_format_full" value="1"> {l s='Creation date' mod='mensagiaprestashop'} </label><br>
                                <label for="ps_date_upd" style="cursor:pointer;" data-toggle="tooltip" title="{l s='Mensagia extra field' mod='mensagiaprestashop'}: ps_date_upd"> <input type="checkbox" id="ps_date_upd" name="ps_date_upd" ps_group="customer" nameToShow="{l s='Last modification date' mod='mensagiaprestashop'}" class="ps_extrafields" extra_field_type="date" date_format_type="date_format_full" value="1"> {l s='Last modification date' mod='mensagiaprestashop'} </label><br>
                                <label for="ps_last_visit" style="cursor:pointer;" data-toggle="tooltip" title="{l s='Mensagia extra field' mod='mensagiaprestashop'}: ps_last_visit"> <input type="checkbox" id="ps_last_visit" name="ps_last_visit" ps_group="connections" nameToShow="{l s='Last visit date' mod='mensagiaprestashop'}" class="ps_extrafields" extra_field_type="date" date_format_type="date_format_full" value="1"> {l s='Last visit date' mod='mensagiaprestashop'} </label><br>
                                <label for="ps_newsletter" style="cursor:pointer;" data-toggle="tooltip" title="{l s='Mensagia extra field' mod='mensagiaprestashop'}: ps_newsletter"> <input type="checkbox" id="ps_newsletter" name="ps_newsletter" ps_group="customer" nameToShow="{l s='Accept newsletter' mod='mensagiaprestashop'}" class="ps_extrafields" extra_field_type="string" value="1" date_format_type=""> {l s='Accept newsletter' mod='mensagiaprestashop'} </label><br>
                            </div>

                            <div class="" style="margin-top:10px;">
                                <label for="markAllCustomers" style="cursor:pointer;font-weight: normal;"> <input type="checkbox" id="markAllCustomers" name="markAllCustomers"  class="markAll" value="1"> {l s='Mark / Unmark all' mod='mensagiaprestashop'}</label><br>
                            </div>
                        </div>

                        <div class="col-lg-3">
                            <div  class="checks">
                                <b style="margin-bottom: 10px;display: block;text-decoration:underline;">{l s='Orders' mod='mensagiaprestashop'}</b>
                                <label for="ps_date_last_order" style="cursor:pointer;" data-toggle="tooltip" title="{l s='Mensagia extra field' mod='mensagiaprestashop'}: ps_date_last_order"> <input type="checkbox" id="ps_date_last_order" name="ps_date_last_order" ps_group="order" nameToShow="{l s='Last order date' mod='mensagiaprestashop'}" class="ps_extrafields" extra_field_type="date" value="1" date_format_type="date_format_full"> {l s='Last order date' mod='mensagiaprestashop'} </label><br>
                                <label for="ps_orders_quantity" style="cursor:pointer;" data-toggle="tooltip" title="{l s='Mensagia extra field' mod='mensagiaprestashop'}: ps_orders_quantity"> <input type="checkbox" id="ps_orders_quantity" name="ps_orders_quantity" ps_group="order" nameToShow="{l s='Number of orders placed' mod='mensagiaprestashop'}" class="ps_extrafields" extra_field_type="number" value="1" date_format_type=""> {l s='Number of orders placed' mod='mensagiaprestashop'} </label><br>
                                <label for="ps_orders_total_spent" style="cursor:pointer;" data-toggle="tooltip" title="{l s='Mensagia extra field' mod='mensagiaprestashop'}: ps_orders_total_spent"> <input type="checkbox" id="ps_orders_total_spent" name="ps_orders_total_spent" ps_group="order" nameToShow="{l s='Total spent' mod='mensagiaprestashop'}" class="ps_extrafields" extra_field_type="number" value="1" date_format_type=""> {l s='Total spent' mod='mensagiaprestashop'} </label><br>
                                <label for="ps_orders_total_spent_current_year" style="cursor:pointer;" data-toggle="tooltip" title="{l s='Mensagia extra field' mod='mensagiaprestashop'}: ps_orders_total_spent_current_year"> <input type="checkbox" id="ps_orders_total_spent_current_year" name="ps_orders_total_spent_current_year" ps_group="order" nameToShow="{l s='Total spent this year' mod='mensagiaprestashop'}" class="ps_extrafields" extra_field_type="number" value="1" date_format_type=""> {l s='Total spent this year' mod='mensagiaprestashop'} </label><br>
                                <label for="ps_orders_total_spent_last_year" style="cursor:pointer;" data-toggle="tooltip" title="{l s='Mensagia extra field' mod='mensagiaprestashop'}: ps_orders_total_spent_last_year"> <input type="checkbox" id="ps_orders_total_spent_last_year" name="ps_orders_total_spent_last_year" ps_group="order" nameToShow="{l s='Total spent the last year' mod='mensagiaprestashop'}" class="ps_extrafields" extra_field_type="number" value="1" date_format_type=""> {l s='Total spent the last year' mod='mensagiaprestashop'} </label><br>
                                <label for="ps_orders_total_spent_current_month" style="cursor:pointer;" data-toggle="tooltip" title="{l s='Mensagia extra field' mod='mensagiaprestashop'}: ps_orders_total_spent_current_month"> <input type="checkbox" id="ps_orders_total_spent_current_month" name="ps_orders_total_spent_current_month" ps_group="order" nameToShow="{l s='Total spent this month' mod='mensagiaprestashop'}" class="ps_extrafields" extra_field_type="number" value="1" date_format_type=""> {l s='Total spent this month' mod='mensagiaprestashop'} </label><br>
                                <label for="ps_orders_total_spent_last_month" style="cursor:pointer;" data-toggle="tooltip" title="{l s='Mensagia extra field' mod='mensagiaprestashop'}: ps_orders_total_spent_last_month"> <input type="checkbox" id="ps_orders_total_spent_last_month" name="ps_orders_total_spent_last_month" ps_group="order" nameToShow="{l s='Total spent the last month' mod='mensagiaprestashop'}" class="ps_extrafields" extra_field_type="number" value="1" date_format_type=""> {l s='Total spent the last month' mod='mensagiaprestashop'} </label><br>
                            </div>

                            <div class="" style="margin-top:10px;">
                                <label for="markAllOrders" style="cursor:pointer;font-weight: normal;"> <input type="checkbox" id="markAllOrders" name="markAllOrders"  class="markAll" value="1"> {l s='Mark / Unmark all' mod='mensagiaprestashop'}</label><br>
                            </div>
                        </div>

                        <div class="col-lg-4">
                            <div  class="checks">
                                <b style="margin-bottom: 10px;display: block;text-decoration:underline;">{l s='Carts' mod='mensagiaprestashop'}</b>
                                <label for="ps_cart_forgotten_last_date" style="cursor:pointer;" data-toggle="tooltip" title="{l s='Mensagia extra field' mod='mensagiaprestashop'}: ps_cart_forgotten_last_date"> <input type="checkbox" id="ps_cart_forgotten_last_date" name="ps_cart_forgotten_last_date" ps_group="cart" nameToShow="{l s='Last forgotten cart date' mod='mensagiaprestashop'}" class="ps_extrafields" extra_field_type="date" value="1" date_format_type="date_format_full"> {l s='Last forgotten cart date' mod='mensagiaprestashop'} </label><br>
                                <label for="ps_cart_forgotten_since_last_purchase" style="cursor:pointer;" data-toggle="tooltip" title="{l s='Mensagia extra field' mod='mensagiaprestashop'}: ps_cart_forgotten_since_last_purchase"> <input type="checkbox" id="ps_cart_forgotten_since_last_purchase" name="ps_cart_forgotten_since_last_purchase" ps_group="cart" nameToShow="{l s='Number of forgotten carts since last purchase' mod='mensagiaprestashop'}" class="ps_extrafields" extra_field_type="number" value="1" date_format_type=""> {l s='Number of forgotten carts since last purchase' mod='mensagiaprestashop'} </label><br>
                            </div>

                            <div class="" style="margin-top:10px;">
                                <label for="markAllCarts" style="cursor:pointer;font-weight: normal;"> <input type="checkbox" id="markAllCarts" name="markAllCarts"  class="markAll" value="1"> {l s='Mark / Unmark all' mod='mensagiaprestashop'}</label><br>
                            </div>
                        </div>

                    </div>

                    <div class="error error_no_primary" style="color:red;font-weight:bold;margin-top:10px;display:none;">{l s='You must choose at least phone number or email to export to Mensagia' mod='mensagiaprestashop'}</div>

                </div>

            </div>

            <div class="form-group priority_field_box" style="margin-top:30px;display:none">
                <label class="control-label col-lg-3">
                    {l s='Choose the main field to search if the contact exists in Messaging' mod='mensagiaprestashop'}
                </label>

                <div class="col-lg-9">
                    <select name="priority_field" id="priority_field" >
                        <option value="number" selected>{l s='Mobile phone' mod='mensagiaprestashop'}</option>
                        <option value="email">{l s='Email' mod='mensagiaprestashop'}</option>
                    </select>
                </div>
            </div>

        </form>

    </div>

    <div class="panel-footer">
        <button type="submit" class="btn btn-default pull-right btnExport" name=""><i class="process-icon-export"></i> {l s='Export groups to Mensagia' mod='mensagiaprestashop'}</button>
    </div>
</div>


<div class="panel panel-export" id='exportBox' style="display: none;">
    <div class="panel-heading"><i class="icon-gear"></i> {l s='Export' mod='mensagiaprestashop'}</div>
    <div class="panel-body">

        <div class="alert alert-danger exportError" style="display:none;">
            {l s='Export has ended unexpectedly. Check the export errors to know the reason.' mod='mensagiaprestashop'}
        </div>

        <div class="alert alert-success exportSuccess" style="display:none;">
            {l s='Export completed successfully.' mod='mensagiaprestashop'}
        </div>

        <div class="progress" style="height:30px">
            <div class="progress-bar progress-bar-info progress-bar-striped active" role="progressbar"
                 aria-valuenow="40" aria-valuemin="0" aria-valuemax="100" style="width:0%;min-width: 2em;height:30px;line-height: 25px;">
                0%
            </div>
        </div>

        <b>{l s='Export processing' mod='mensagiaprestashop'}</b>
        <div class="export_process" style="border:1px solid #aaa; padding:10px;height:230px;overflow-y:scroll;"></div>
        <br>
        <b>{l s='Export errors' mod='mensagiaprestashop'}</b>
        <div class="export_process_errors" style="border:1px solid #aaa; padding:10px;color:red;height:230px;overflow-y:scroll;"></div>
    </div>
</div>

{include file="./../partials/modalDemo.tpl"}
{include file="./../partials/logoFooter.tpl"}

<script>
    var language_id         = {$language_id};
    var default_language_id = {$default_language_id};
    var date_format_lite    = '{$date_format_lite}';
    var date_format_full    = '{$date_format_full}';
    var prefix_mode         = '{$prefix_mode}';
</script>