{*
* 2007-2016 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <info@mensagia.com>
*  @copyright  2017 Sinermedia
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}

{if ($show_content)}
    <div class="panel">

        <div class="panel-heading"><i class="icon-gear"></i> {l s='Order Status' mod='mensagiaprestashop'}</div>
        <div class="panel-body bodyForms">

            <ul class="nav nav-tabs">
                <li role="presentation" class="active" ><a href="#" mustOpen="notif_estado_pedido_cliente" mustOpenClass="notif_estado_pedido" class="toogleTypeNotification">{l s='Customer notifications' mod='mensagiaprestashop'}</a></li>
                <li role="presentation"><a href="#" mustOpen="notif_estado_pedido_admin" mustOpenClass="notif_estado_pedido" class="toogleTypeNotification">{l s='Administrators notifications' mod='mensagiaprestashop'}</a></li>
            </ul>

            <div id="notif_estado_pedido_admin" class='notif_estado_pedido' style="border:1px solid #ddd; padding:20px;background:#fff;display:none;">

                <h2>{l s='Administrators: Order status' mod='mensagiaprestashop'}</h2>

                <table class="table " width="70%" cellpadding="5" cellspacing="10" align="center">
                    <tbody>
                    {foreach from=$hooksOrderStatesAdmin item=curr}
                        <tr id="t_admin_actionOrderStatusPostUpdate_{$curr['option_id']|escape:'htmlall':'UTF-8'}" height="60px" class="trvisible">
                            <td width="500">{$orderStatesNames['actionOrderStatusPostUpdate_'|cat:$curr['id']|escape:'htmlall':'UTF-8']}</td>
                            <td><input type="checkbox" class='toggleNotification actionOrderStatusPostUpdate' name="admin_actionOrderStatusPostUpdate_{$curr['option_id']|escape:'htmlall':'UTF-8'}" id="admin_actionOrderStatusPostUpdate_{$curr['option_id']|escape:'htmlall':'UTF-8'}" {if $mensagiaSMSNotifications['admin_actionOrderStatusPostUpdate_'|cat:$curr['option_id']]}checked{/if}  htype="admin" hook="actionOrderStatusPostUpdate" hid="{$curr['option_id']|escape:'htmlall':'UTF-8'}" data-onstyle="success"></td>
                            <td><span class="openMsgSelector" style="text-decoration:underline;" opened="false" related="h_admin_actionOrderStatusPostUpdate_{$curr['option_id']|escape:'htmlall':'UTF-8'}" ><i class="icon-edit" aria-hidden="true"></i> {l s='Edit notification' mod='mensagiaprestashop'}</span></td>
                        </tr>

                        <tr id="h_admin_actionOrderStatusPostUpdate_{$curr['option_id']|escape:'htmlall':'UTF-8'}" style="display:none;">
                            <td colspan="3">
                                {include file="./textarea.tpl" languages=$admin_lang_default curr=$curr name="h_admin_actionOrderStatusPostUpdate_{$curr['option_id']|escape:'htmlall':'UTF-8'}"}
                            </td>
                        </tr>

                    {/foreach}
                    </tbody>

                </table>

                <br><h2>{l s='Administrators: Orders' mod='mensagiaprestashop'}</h2>

                <table class="table " width="70%" cellpadding="5" cellspacing="10" align="center">
                    <tbody>

                    <tr id="t_admin_actionValidateOrder" height="60px" class="trvisible">
                        <td width="500">{l s='New order' mod='mensagiaprestashop'}</td>
                        <td><input type="checkbox" class='toggleNotification actionValidateOrder' name="admin_actionValidateOrder" id="admin_actionValidateOrder" {if $mensagiaSMSNotifications['admin_actionValidateOrder']}checked{/if}  htype="admin" hook="actionValidateOrder" hid="" data-onstyle="success"></td>
                        <td><span class="openMsgSelector" style="text-decoration:underline;" opened="false" related="h_admin_actionValidateOrder" ><i class="icon-edit" aria-hidden="true"></i> {l s='Edit notification' mod='mensagiaprestashop'}</span></td>
                    </tr>

                    <tr id="h_admin_actionValidateOrder" style="display:none;">
                        <td colspan="3">
                            {$curr = ['id' => $idsNamesNotifications['admin_actionValidateOrder']]}
                            {include file="./textarea.tpl" languages=$admin_lang_default curr=$curr name="h_admin_actionValidateOrder"}
                        </td>
                    </tr>

                    <tr id="t_admin_actionPaymentConfirmation" height="60px" class="trvisible">
                        <td width="500">{l s='Payment completed' mod='mensagiaprestashop'}</td>
                        <td><input type="checkbox" class='toggleNotification actionPaymentConfirmation' name="admin_actionPaymentConfirmation" id="admin_actionPaymentConfirmation" {if $mensagiaSMSNotifications['admin_actionPaymentConfirmation']}checked{/if}  htype="admin" hook="actionPaymentConfirmation" hid="" data-onstyle="success"></td>
                        <td><span class="openMsgSelector" style="text-decoration:underline;" opened="false" related="h_admin_actionPaymentConfirmation" ><i class="icon-edit" aria-hidden="true"></i> {l s='Edit notification' mod='mensagiaprestashop'}</span></td>
                    </tr>

                    <tr id="h_admin_actionPaymentConfirmation" style="display:none;">
                        <td colspan="3">
                            {$curr = ['id' => $idsNamesNotifications['admin_actionPaymentConfirmation']]}
                            {include file="./textarea.tpl" languages=$admin_lang_default curr=$curr name="h_admin_actionPaymentConfirmation"}
                        </td>
                    </tr>

                    <tr id="t_admin_actionOrderReturn" height="60px" class="trvisible">
                        <td width="500">{l s='Order returns' mod='mensagiaprestashop'}</td>
                        <td><input type="checkbox" class='toggleNotification actionOrderReturn' name="admin_actionOrderReturn" id="admin_actionOrderReturn" {if $mensagiaSMSNotifications['admin_actionOrderReturn']}checked{/if}  htype="admin" hook="actionOrderReturn" hid="" data-onstyle="success"></td>
                        <td><span class="openMsgSelector" style="text-decoration:underline;" opened="false" related="h_admin_actionOrderReturn" ><i class="icon-edit" aria-hidden="true"></i> {l s='Edit notification' mod='mensagiaprestashop'}</span></td>
                    </tr>

                    <tr id="h_admin_actionOrderReturn" style="display:none;">
                        <td colspan="3">
                            {$curr = ['id' => $idsNamesNotifications['admin_actionOrderReturn']]}
                            {include file="./textarea.tpl" languages=$admin_lang_default curr=$curr name="h_admin_actionOrderReturn"}
                        </td>
                    </tr>

                    </tbody>

                </table>

                <br><h2>{l s='Administrators: Accounts' mod='mensagiaprestashop'}</h2>

                <table class="table " width="70%" cellpadding="5" cellspacing="10" align="center">
                    <tbody>
                        <tr id="t_admin_actionCustomerAccountAdd" height="60px" class="trvisible">
                            <td width="500">{l s='Customer account successfully created' mod='mensagiaprestashop'}</td>
                            <td><input type="checkbox" class='toggleNotification actionCustomerAccountAdd' name="admin_actionCustomerAccountAdd" id="admin_actionCustomerAccountAdd" {if $mensagiaSMSNotifications['admin_actionCustomerAccountAdd']}checked{/if}  htype="admin" hook="actionCustomerAccountAdd" hid="" data-onstyle="success"></td>
                            <td><span class="openMsgSelector" style="text-decoration:underline;" opened="false" related="h_admin_actionCustomerAccountAdd" ><i class="icon-edit" aria-hidden="true"></i> {l s='Edit notification' mod='mensagiaprestashop'}</span></td>
                        </tr>

                        <tr id="h_admin_actionCustomerAccountAdd" style="display:none;">
                            <td colspan="3">
                                {$curr = ['id' => $idsNamesNotifications['admin_actionCustomerAccountAdd']]}
                                {include file="./textarea.tpl" languages=$admin_lang_default curr=$curr name="h_admin_actionCustomerAccountAdd"}
                            </td>
                        </tr>
                    </tbody>
                </table>


                <br><h2>{l s='Administrators: Products' mod='mensagiaprestashop'}</h2>

                <table class="table " width="70%" cellpadding="5" cellspacing="10" align="center">
                    <tbody>

                    <tr id="t_admin_actionProductDelete" height="60px" class="trvisible">
                        <td width="500">{l s='Product deleted' mod='mensagiaprestashop'}</td>
                        <td><input type="checkbox" class='toggleNotification actionProductDelete' name="admin_actionProductDelete" id="admin_actionProductDelete" {if $mensagiaSMSNotifications['admin_actionProductDelete']}checked{/if}  htype="admin" hook="actionProductDelete" hid="" data-onstyle="success"></td>
                        <td><span class="openMsgSelector" style="text-decoration:underline;" opened="false" related="h_admin_actionProductDelete" ><i class="icon-edit" aria-hidden="true"></i> {l s='Edit notification' mod='mensagiaprestashop'}</span></td>
                    </tr>

                    <tr id="h_admin_actionProductDelete" style="display:none;">
                        <td colspan="3">
                            {$curr = ['id' => $idsNamesNotifications['admin_actionProductDelete']]}
                            {include file="./textarea.tpl" languages=$admin_lang_default curr=$curr name="h_admin_actionProductDelete"}
                        </td>
                    </tr>
                    </tbody>
                </table>

            </div>

            <div id="notif_estado_pedido_cliente" class='notif_estado_pedido' style="border:1px solid #ddd; padding:20px;background:#fff;">

                <h2>{l s='Customers: Order states' mod='mensagiaprestashop'}</h2>

                <table class="table " width="70%" cellpadding="5" cellspacing="10" align="center">
                    <tbody>
                    {foreach from=$hooksOrderStatesCustomer item=curr}
                        <tr id="t_customer_actionOrderStatusPostUpdate_{$curr['option_id']|escape:'htmlall':'UTF-8'}" height="60px" class="trvisible">
                            <td width="500">{$orderStatesNames['actionOrderStatusPostUpdate_'|cat:$curr['id']|escape:'htmlall':'UTF-8']}</td>
                            <td><input type="checkbox" class='toggleNotification actionOrderStatusPostUpdate' name="customer_actionOrderStatusPostUpdate_{$curr['option_id']|escape:'htmlall':'UTF-8'}" id="customer_actionOrderStatusPostUpdate_{$curr['option_id']|escape:'htmlall':'UTF-8'}" {if $mensagiaSMSNotifications['customer_actionOrderStatusPostUpdate_'|cat:$curr['option_id']]}checked{/if}  htype="customer" hook="actionOrderStatusPostUpdate" hid="{$curr['option_id']|escape:'htmlall':'UTF-8'}" data-onstyle="success"></td>
                            <td><span class="openMsgSelector" style="text-decoration:underline;" opened="false" related="h_customer_actionOrderStatusPostUpdate_{$curr['option_id']|escape:'htmlall':'UTF-8'}" ><i class="icon-edit" aria-hidden="true"></i> {l s='Edit notification' mod='mensagiaprestashop'}</span></td>
                        </tr>

                        <tr id="h_customer_actionOrderStatusPostUpdate_{$curr['option_id']|escape:'htmlall':'UTF-8'}" style="display:none;">
                            <td colspan="3">
                                {include file="./textarea.tpl" languages=$languages curr=$curr name="h_customer_actionOrderStatusPostUpdate_{$curr['option_id']|escape:'htmlall':'UTF-8'}"}
                            </td>
                        </tr>

                    {/foreach}
                    </tbody>

                </table>


                <br><h2>{l s='Customers: Orders' mod='mensagiaprestashop'}</h2>

                <table class="table " width="70%" cellpadding="5" cellspacing="10" align="center">
                    <tbody>

                        <tr id="t_customer_actionValidateOrder" height="60px" class="trvisible">
                            <td width="500">{l s='New order' mod='mensagiaprestashop'}</td>
                            <td><input type="checkbox" class='toggleNotification actionValidateOrder' name="customer_actionValidateOrder" id="customer_actionValidateOrder" {if $mensagiaSMSNotifications['customer_actionValidateOrder']}checked{/if}  htype="customer" hook="actionValidateOrder" hid="" data-onstyle="success"></td>
                            <td><span class="openMsgSelector" style="text-decoration:underline;" opened="false" related="h_customer_actionValidateOrder" ><i class="icon-edit" aria-hidden="true"></i> {l s='Edit notification' mod='mensagiaprestashop'}</span></td>
                        </tr>

                        <tr id="h_customer_actionValidateOrder" style="display:none;">
                            <td colspan="3">
                                {$curr = ['id' => $idsNamesNotifications['customer_actionValidateOrder']]}
                                {include file="./textarea.tpl" languages=$languages curr=$curr name="h_customer_actionValidateOrder"}
                            </td>
                        </tr>


                        <tr id="t_customer_actionPaymentConfirmation" height="60px" class="trvisible">
                            <td width="500">{l s='Payment completed' mod='mensagiaprestashop'}</td>
                            <td><input type="checkbox" class='toggleNotification actionPaymentConfirmation' name="customer_actionPaymentConfirmation" id="customer_actionPaymentConfirmation" {if $mensagiaSMSNotifications['customer_actionPaymentConfirmation']}checked{/if}  htype="customer" hook="actionPaymentConfirmation" hid="" data-onstyle="success"></td>
                            <td><span class="openMsgSelector" style="text-decoration:underline;" opened="false" related="h_customer_actionPaymentConfirmation" ><i class="icon-edit" aria-hidden="true"></i> {l s='Edit notification' mod='mensagiaprestashop'}</span></td>
                        </tr>

                        <tr id="h_customer_actionPaymentConfirmation" style="display:none;">
                            <td colspan="3">
                                {$curr = ['id' => $idsNamesNotifications['customer_actionPaymentConfirmation']]}
                                {include file="./textarea.tpl" languages=$languages curr=$curr name="h_customer_actionPaymentConfirmation"}
                            </td>
                        </tr>


                        <tr id="t_customer_actionOrderReturn" height="60px" class="trvisible">
                            <td width="500">{l s='Order returns' mod='mensagiaprestashop'}</td>
                            <td><input type="checkbox" class='toggleNotification actionOrderReturn' name="customer_actionOrderReturn" id="customer_actionOrderReturn" {if $mensagiaSMSNotifications['customer_actionOrderReturn']}checked{/if}  htype="customer" hook="actionOrderReturn" hid="" data-onstyle="success"></td>
                            <td><span class="openMsgSelector" style="text-decoration:underline;" opened="false" related="h_customer_actionOrderReturn" ><i class="icon-edit" aria-hidden="true"></i> {l s='Edit notification' mod='mensagiaprestashop'}</span></td>
                        </tr>

                        <tr id="h_customer_actionOrderReturn" style="display:none;">
                            <td colspan="3">
                                {$curr = ['id' => $idsNamesNotifications['customer_actionOrderReturn']]}
                                {include file="./textarea.tpl" languages=$languages curr=$curr name="h_customer_actionOrderReturn"}
                            </td>
                        </tr>

                    </tbody>

                </table>

            </div>


        </div>
    </div>
{else}
    {if (!Configuration::get('MENSAGIA_API_CONFIGURATION'))}
    <div class="alert alert-warning">
        <b>{l s='Attention!' mod='mensagiaprestashop'}</b>: {l s='You must choose a source address configuration in order to use SMS Notifications' mod='mensagiaprestashop'}
    </div>
    {/if}

    {if !count($admins) }
    <div class="alert alert-warning">
        <b>{l s='Attention!' mod='mensagiaprestashop'}</b>: {l s='You do not have administrators created, you must create at least one to use SMS Notifications.' mod='mensagiaprestashop'}
    </div>
    {/if}

    <p>{l s='Go to [1]Configuration of the Mensagia module[/1] to configure the missing options to be able to use SMS Notifications' tags=["<a href='{$url_redirect}'>"] mod='mensagiaprestashop'}</p>
{/if}

{include file="./../partials/modalDemo.tpl"}
{include file="./../partials/logoFooter.tpl"}

<script>
    var notificacion_activada       = '{l s='Notification ACTIVATED' mod='mensagiaprestashop'}';
    var notificacion_desactivada    = '{l s='Notification disabled' mod='mensagiaprestashop'}';
    var token_mod                   = '{Tools::getAdminToken('mensagia_prestashop')|escape:'htmlall':'UTF-8'}';


    var example = [];
    example['{literal}{customer_id}{/literal}']                 = 234;
    example['{literal}{customer_firstname}{/literal}']          = "Peter";
    example['{literal}{customer_lastname}{/literal}']           = "Smith";
    example['{literal}{customer_email}{/literal}']              = "petersmith@mail.com";
    example['{literal}{customer_company}{/literal}']            = "SmithCompany";
    example['{literal}{customer_address1}{/literal}']           = "Boulevard St. 12";
    example['{literal}{customer_address2}{/literal}']           = "4-1";
    example['{literal}{customer_postcode}{/literal}']           = "08080";
    example['{literal}{customer_city}{/literal}']               = "Girona";
    example['{literal}{customer_country}{/literal}']            = "España";
    example['{literal}{customer_state}{/literal}']              = "Barcelona";
    example['{literal}{customer_phone}{/literal}']              = "3491200300";
    example['{literal}{customer_mobile}{/literal}']             = "34687400300";
    example['{literal}{customer_vat_number}{/literal}']         = "1732403-3"
    example['{literal}{customer_invoice_firstname}{/literal}']  = "Peter";
    example['{literal}{customer_invoice_lastname}{/literal}']   = "Smith";
    example['{literal}{customer_invoice_company}{/literal}']    = "SmithCompany";
    example['{literal}{customer_invoice_address}{/literal}']    = "Boulevard St. 12";
    example['{literal}{customer_invoice_postcode}{/literal}']   = "08080";
    example['{literal}{customer_invoice_city}{/literal}']       = "Girona";
    example['{literal}{customer_invoice_country}{/literal}']    = "España";
    example['{literal}{customer_invoice_state}{/literal}']      = "España";
    example['{literal}{customer_invoice_phone}{/literal}']      = "3491200300";
    example['{literal}{customer_invoice_mobile}{/literal}']     = "34687400300";
    example['{literal}{customer_invoice_vat_number}{/literal}'] = "1732403-3";
    example['{literal}{shop_name}{/literal}']                   = "MiTienda";
    example['{literal}{shop_domain}{/literal}']                 = "www.mitienda.com";
    example['{literal}{shop_email}{/literal}']                  = "email@mitienda.com";
    example['{literal}{shop_phone}{/literal}']                  = "34972653472";
    example['{literal}{order_id}{/literal}']                    = "243";
    example['{literal}{order_payment}{/literal}']               = "Bank Wire";
    example['{literal}{order_total_paid}{/literal}']            = "123";
    example['{literal}{order_currency}{/literal}']              = "EUR";
    example['{literal}{order_delivery_format_es}{/literal}']    = "29-12-2020";
    example['{literal}{order_delivery_format_en}{/literal}']    = "2020-12-29";
    example['{literal}{order_invoice_format_es}{/literal}']     = "25-12-2020";
    example['{literal}{order_invoice_format_en}{/literal}']     = "2020-12-25";
    example['{literal}{order_shipping_number}{/literal}']       = "123456789000";
    example['{literal}{order_reference}{/literal}']             = "SDFDSOVSDX23";
    example['{literal}{carrier_id}{/literal}']                  = "1";
    example['{literal}{carrier_name}{/literal}']                = "My Carrier";
    example['{literal}{product_id}{/literal}']                  = "23";
    example['{literal}{product_name}{/literal}']                = "Zapatillas de Deporte";
    example['{literal}{product_ref}{/literal}']                 = "DFJ3LFDSA";
    example['{literal}{employee_id}{/literal}']                 = "2";
    example['{literal}{employee_firstname}{/literal}']          = "Javier";
    example['{literal}{employee_lastname}{/literal}']           = "Ibarra";
    example['{literal}{employee_email}{/literal}']              = "jibarra@prestashop.com";
</script>





